/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.resourcestab;

import filenet.sim.api.VWScenarioShiftDefinition;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.sim.toolkit.designer.properties.resourcestab.VWSIMDailyPropertiesPanel;
import filenet.sim.toolkit.designer.properties.resourcestab.VWSIMOncePropertiesPanel;
import filenet.sim.toolkit.designer.properties.resourcestab.VWSIMWeeklyPropertiesPanel;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.uicontrols.calendar.VWDateTimeFormat;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class VWSIMStartDateTimePanel
extends JPanel
implements ActionListener {
    private JPanel m_choicesPanel = null;
    private JRadioButton m_onceRadioButton = null;
    private JRadioButton m_dailyRadioButton = null;
    private JRadioButton m_weeklyRadioButton = null;
    private CardLayout m_layout = null;
    private JPanel m_propertiesPanel = null;
    private VWSIMOncePropertiesPanel m_oncePropertiesPanel = null;
    private VWSIMDailyPropertiesPanel m_dailyPropertiesPanel = null;
    private VWSIMWeeklyPropertiesPanel m_weeklyPropertiesPanel = null;
    private VWSIMPropertyData m_propertyData = null;
    private VWScenarioShiftDefinition m_shiftDef = null;

    public void init(VWSIMPropertyData propertyData) {
        this.m_propertyData = propertyData;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.initChoicesControls();
        this.initPropertiesControls();
    }

    public void setShiftDefinition(VWScenarioShiftDefinition shiftDef) {
        this.m_shiftDef = shiftDef;
        this.reinitialize();
    }

    public void setEnabled(boolean bEnable) {
        this.m_onceRadioButton.setEnabled(bEnable);
        this.m_dailyRadioButton.setEnabled(bEnable);
        this.m_weeklyRadioButton.setEnabled(bEnable);
        this.m_oncePropertiesPanel.setEnabled(bEnable);
        this.m_dailyPropertiesPanel.setEnabled(bEnable);
        this.m_weeklyPropertiesPanel.setEnabled(bEnable);
        super.setEnabled(bEnable);
    }

    public void releaseReferences() {
        this.m_onceRadioButton = null;
        this.m_dailyRadioButton = null;
        this.m_weeklyRadioButton = null;
        this.m_oncePropertiesPanel = null;
        this.m_dailyPropertiesPanel = null;
        this.m_weeklyPropertiesPanel = null;
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_onceRadioButton) {
            this.performOnceRadioButtonAction();
        } else if (src == this.m_dailyRadioButton) {
            this.performDailyRadioButtonAction();
        } else if (src == this.m_weeklyRadioButton) {
            this.performWeeklyRadioButtonAction();
        }
    }

    private void initChoicesControls() {
        this.m_choicesPanel = new JPanel();
        this.m_choicesPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.anchor = 22;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.insets = new Insets(5, 15, 5, 5);
        this.m_onceRadioButton = new JRadioButton(VWSIMResource.s_once);
        this.m_onceRadioButton.setSelected(true);
        this.m_onceRadioButton.addActionListener(this);
        this.m_choicesPanel.add((Component)this.m_onceRadioButton, gbCons);
        this.m_dailyRadioButton = new JRadioButton(VWSIMResource.s_daily);
        this.m_dailyRadioButton.setSelected(false);
        this.m_dailyRadioButton.addActionListener(this);
        ++gbCons.gridx;
        this.m_choicesPanel.add((Component)this.m_dailyRadioButton, gbCons);
        this.m_weeklyRadioButton = new JRadioButton(VWSIMResource.s_weekly);
        this.m_weeklyRadioButton.setSelected(false);
        this.m_weeklyRadioButton.addActionListener(this);
        ++gbCons.gridx;
        this.m_choicesPanel.add((Component)this.m_weeklyRadioButton, gbCons);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_onceRadioButton);
        group.add(this.m_dailyRadioButton);
        group.add(this.m_weeklyRadioButton);
        ++gbCons.gridx;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        this.m_choicesPanel.add((Component)new JLabel(), gbCons);
        this.add((Component)this.m_choicesPanel, "First");
    }

    private void initPropertiesControls() {
        this.m_layout = new CardLayout();
        this.m_propertiesPanel = new JPanel(this.m_layout);
        this.m_oncePropertiesPanel = new VWSIMOncePropertiesPanel();
        this.m_oncePropertiesPanel.init(this.m_propertyData);
        this.m_propertiesPanel.add(VWSIMResource.s_oncePanel, this.m_oncePropertiesPanel);
        this.m_dailyPropertiesPanel = new VWSIMDailyPropertiesPanel();
        this.m_dailyPropertiesPanel.init(this.m_propertyData);
        this.m_propertiesPanel.add(VWSIMResource.s_dailyPanel, this.m_dailyPropertiesPanel);
        this.m_weeklyPropertiesPanel = new VWSIMWeeklyPropertiesPanel();
        this.m_weeklyPropertiesPanel.init(this.m_propertyData);
        this.m_propertiesPanel.add(VWSIMResource.s_weeklyPanel, this.m_weeklyPropertiesPanel);
        this.add((Component)this.m_propertiesPanel, "Center");
        this.m_layout.show(this.m_propertiesPanel, VWSIMResource.s_oncePanel);
    }

    private void performOnceRadioButtonAction() {
        try {
            int nType = this.m_shiftDef.getScheduleType();
            this.m_shiftDef.setScheduleType(1);
            if (nType != 1) {
                try {
                    long timeValue = this.m_shiftDef.getStartTime();
                    Date now = new Date();
                    String date = VWDateTimeFormat.getDateString(now);
                    String time = VWDateTimeFormat.convertSecondsToTimeString(timeValue);
                    String dateTime = date + " " + time;
                    Date newDateTimeObj = VWDateTimeFormat.getDateObject(dateTime);
                    this.m_shiftDef.setStartTime(newDateTimeObj.getTime());
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            }
            this.m_propertyData.setDirty();
            this.m_oncePropertiesPanel.setShiftDefinition(this.m_shiftDef);
            this.m_layout.show(this.m_propertiesPanel, VWSIMResource.s_oncePanel);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performDailyRadioButtonAction() {
        try {
            int nType = this.m_shiftDef.getScheduleType();
            this.m_shiftDef.setScheduleType(2);
            if (nType == 1) {
                long dateValue = this.m_shiftDef.getStartTime();
                String time = VWDateTimeFormat.getTimeString(new Date(dateValue));
                long timeValue = VWDateTimeFormat.convertTimeStringToSeconds(time);
                this.m_shiftDef.setStartTime(timeValue);
            }
            this.m_propertyData.setDirty();
            this.m_dailyPropertiesPanel.setShiftDefinition(this.m_shiftDef);
            this.m_layout.show(this.m_propertiesPanel, VWSIMResource.s_dailyPanel);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performWeeklyRadioButtonAction() {
        try {
            int nType = this.m_shiftDef.getScheduleType();
            this.m_shiftDef.setScheduleType(3);
            if (nType == 1) {
                long dateValue = this.m_shiftDef.getStartTime();
                String time = VWDateTimeFormat.getTimeString(new Date(dateValue));
                long timeValue = VWDateTimeFormat.convertTimeStringToSeconds(time);
                this.m_shiftDef.setStartTime(timeValue);
                this.m_shiftDef.setActiveDays(31);
            }
            this.m_propertyData.setDirty();
            this.m_weeklyPropertiesPanel.setShiftDefinition(this.m_shiftDef);
            this.m_layout.show(this.m_propertiesPanel, VWSIMResource.s_weeklyPanel);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void reinitialize() {
        if (this.m_shiftDef == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
        switch (this.m_shiftDef.getScheduleType()) {
            case 1: {
                this.m_layout.show(this.m_propertiesPanel, VWSIMResource.s_oncePanel);
                this.m_onceRadioButton.removeActionListener(this);
                this.m_onceRadioButton.setSelected(true);
                this.m_onceRadioButton.addActionListener(this);
                this.m_oncePropertiesPanel.setShiftDefinition(this.m_shiftDef);
                break;
            }
            case 2: {
                this.m_layout.show(this.m_propertiesPanel, VWSIMResource.s_dailyPanel);
                this.m_dailyRadioButton.removeActionListener(this);
                this.m_dailyRadioButton.setSelected(true);
                this.m_dailyRadioButton.addActionListener(this);
                this.m_dailyPropertiesPanel.setShiftDefinition(this.m_shiftDef);
                break;
            }
            case 3: {
                this.m_layout.show(this.m_propertiesPanel, VWSIMResource.s_weeklyPanel);
                this.m_weeklyRadioButton.removeActionListener(this);
                this.m_weeklyRadioButton.setSelected(true);
                this.m_weeklyRadioButton.addActionListener(this);
                this.m_weeklyPropertiesPanel.setShiftDefinition(this.m_shiftDef);
            }
        }
    }
}

